#pragma GCC optimize ("-Os")
#include <avr/pgmspace.h>
#include <avr/interrupt.h>
#include <avr/io.h>

#define A0_ON PORTD|=0x04 // A
#define A0_OFF PORTD&=~0x04 // Arduino Uno 2번핀
#define A1_ON PORTD|=0x08 // B
#define A1_OFF PORTD&=~0x08 // Arduino Uno 3번핀
#define A2_ON PORTD|=0x10 // C
#define A2_OFF PORTD&=~0x10 // Arduino Uno 4번핀
#define A3_ON PORTD|=0x20 // C
#define A3_OFF PORTD&=~0x20 // Arduino Uno 5번핀
#define Data_Red_ON PORTD|=0x40 // Red
#define Data_Red_OFF PORTD&=~0x40 // Arduino Uno 6번핀
#define Data_Green_ON PORTD|=0x80 // Green
#define Data_Green_OFF PORTD&=~0x80 // Arduino Uno 7번핀

#define LE_ON PORTC|=0x08 // Latch_Enable(LE)
#define LE_OFF PORTC&=~0x08 // Arduino Uno A3번핀 

#define Clk_ON PORTB|=0x10 // Clk
#define Clk_OFF PORTB&=~0x10 // Arduino Uno 12번핀

#define OE_ON PORTB&=~0x20 // Output_Enable(OE)
#define OE_OFF PORTB|=0x20 // Arduino Uno 13번핀

#define Yellow 0
#define Red 1
#define Green 2

#define in1 0
#define in2 1
#define in3 2
#define in4 3
#define in5 4
#define in6 5
#define in7 6
#define in8 7
#define in9 8
#define in10 9
#define in11 10
#define in12 11
#define in13 12
#define in14 13
#define in15 14
#define in16 15
#define in17 16
#define in18 17
#define in19 18
#define in20 19
#define in21 20
#define in22 21
#define in23 22
#define in24 23
#define in25 24
#define in26 25
#define in27 26
#define in28 27
#define in29 28
#define in30 29
#define in31 30
#define in32 31
#define in33 32
#define in34 33
#define in35 34
#define in36 35
#define in37 36
#define in38 37
#define in39 38
#define in40 39
#define in41 40
#define in42 41

const unsigned int __attribute__((progmem)) string_test[50][16] = {
  0x00, 0x00, 0x1800, 0x18fc, 0x1980, 0x1980, 0x1980, 0x7980, 0x18c0, 0x18c0, 0x1860, 0x1830, 0x181c, 0x1800, 0x00, 0x00, //가
  0x00, 0x00, 0x1800, 0x180c, 0x180c, 0x180c, 0x180c, 0x780c, 0x180c, 0x180c, 0x180c, 0x1ff8, 0x1800, 0x1800, 0x00, 0x00, //나
  0x00, 0x00, 0x1800, 0x1bf8, 0x180c, 0x180c, 0x180c, 0x780c, 0x180c, 0x180c, 0x180c, 0x180c, 0x1ff8, 0x1800, 0x00, 0x00, //다
  0x00, 0x00, 0x1800, 0x18fc, 0x1980, 0x1980, 0x1980, 0x78f8, 0x180c, 0x180c, 0x180c, 0x180c, 0x1ff8, 0x1800, 0x00, 0x00, //라
  0x00, 0x00, 0x1800, 0x19fc, 0x198c, 0x198c, 0x198c, 0x798c, 0x198c, 0x198c, 0x198c, 0x198c, 0x19fc, 0x1800, 0x00, 0x00, //마
  0x00, 0x00, 0x1800, 0x198c, 0x198c, 0x198c, 0x198c, 0x79fc, 0x198c, 0x198c, 0x198c, 0x198c, 0x18f8, 0x1800, 0x00, 0x00, //바
  0x00, 0x00, 0x1800, 0x1860, 0x1860, 0x1860, 0x1860, 0x7870, 0x18f0, 0x18f0, 0x1998, 0x1998, 0x1b0c, 0x1800, 0x00, 0x00, //사
  0x00, 0x00, 0x1800, 0x18f8, 0x198c, 0x198c, 0x198c, 0x798c, 0x198c, 0x198c, 0x198c, 0x198c, 0x18f8, 0x1800, 0x00, 0x00, //아
  0x00, 0x00, 0x1800, 0x1bfc, 0x1860, 0x1860, 0x1860, 0x7860, 0x18f0, 0x18f0, 0x1998, 0x1998, 0x1b0c, 0x1800, 0x00, 0x00, //자
  0x00, 0x00, 0x1800, 0x18f0, 0x1800, 0x1bfc, 0x1860, 0x7860, 0x1860, 0x18f0, 0x18f0, 0x1998, 0x1b0c, 0x1800, 0x00, 0x00, //차
  0x00, 0x00, 0x1800, 0x18fc, 0x1980, 0x1980, 0x1980, 0x79fc, 0x18c0, 0x18c0, 0x1860, 0x1830, 0x181c, 0x1800, 0x00, 0x00, //카
  0x00, 0x00, 0x1800, 0x1bf8, 0x180c, 0x180c, 0x180c, 0x79fc, 0x180c, 0x180c, 0x180c, 0x180c, 0x1ff8, 0x1800, 0x00, 0x00, //타
  0x00, 0x00, 0x1800, 0x1ffc, 0x1800, 0x19b0, 0x19b0, 0x79b0, 0x19b0, 0x19b0, 0x19b0, 0x19b0, 0x1ffc, 0x1800, 0x00, 0x00, //파
  0x00, 0x00, 0x1800, 0x18f0, 0x1800, 0x1bfc, 0x1800, 0x78f0, 0x1998, 0x1998, 0x1998, 0x1998, 0x18f0, 0x1800, 0x00, 0x00, //하
  0x00, 0x00, 0x00, 0x180, 0x180, 0x3c0, 0x3c0, 0x660, 0x660, 0x7e0, 0xc30, 0xc30, 0xc30, 0x00, 0x00, 0x00, //A
  0x00, 0x00, 0x00, 0x7f0, 0xc30, 0xc30, 0xc30, 0x7f0, 0xc30, 0xc30, 0xc30, 0xc30, 0x7f0, 0x00, 0x00, 0x00, //B
  0x00, 0x00, 0x00, 0x7c0, 0xc60, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xc60, 0x7c0, 0x00, 0x00, 0x00, //C
  0x00, 0x00, 0x00, 0x3f0, 0x630, 0xc30, 0xc30, 0xc30, 0xc30, 0xc30, 0xc30, 0x630, 0x3f0, 0x00, 0x00, 0x00, //D
  0x00, 0x00, 0x00, 0x7f0, 0x30, 0x30, 0x30, 0x7f0, 0x30, 0x30, 0x30, 0x30, 0x7f0, 0x00, 0x00, 0x00, //E
  0x00, 0x00, 0x00, 0x7f0, 0x30, 0x30, 0x30, 0x7f0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, //F
  0x00, 0x00, 0x00, 0x7c0, 0xc60, 0x1830, 0x30, 0x30, 0x1f30, 0x1830, 0x1830, 0x1c60, 0x1fc0, 0x00, 0x00, 0x00, //G
  0x00, 0x00, 0x00, 0xc30, 0xc30, 0xc30, 0xc30, 0xff0, 0xc30, 0xc30, 0xc30, 0xc30, 0xc30, 0x00, 0x00, 0x00, //H
  0x00, 0x00, 0x00, 0x180, 0x180, 0x180, 0x180, 0x180, 0x180, 0x180, 0x180, 0x180, 0x180, 0x00, 0x00, 0x00, //I
  0x00, 0x00, 0x00, 0x300, 0x300, 0x300, 0x300, 0x300, 0x300, 0x300, 0x330, 0x330, 0x1e0, 0x00, 0x00, 0x00, //J
  0x00, 0x00, 0x00, 0xc60, 0x660, 0x360, 0x1e0, 0xe0, 0x1e0, 0x360, 0x660, 0xc60, 0x1860, 0x00, 0x00, 0x00, //K
  0x00, 0x00, 0x00, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0xfe0, 0x00, 0x00, 0x00, //L
  0x00, 0x00, 0x00, 0x1818, 0x1818, 0x1c38, 0x1c38, 0x1e78, 0x1e78, 0x1bd8, 0x1bd8, 0x1998, 0x1998, 0x00, 0x00, 0x00, //M
  0x00, 0x00, 0x00, 0xc30, 0xc70, 0xc70, 0xcf0, 0xdb0, 0xdb0, 0xf30, 0xe30, 0xe30, 0xc30, 0x00, 0x00, 0x00, //N
  0x00, 0x00, 0x00, 0x7c0, 0xc60, 0x1830, 0x1830, 0x1830, 0x1830, 0x1830, 0x1830, 0xc60, 0x7c0, 0x00, 0x00, 0x00, //O
  0x00, 0x00, 0x00, 0x7f0, 0xc30, 0xc30, 0xc30, 0xc30, 0x7f0, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, //P
  0x00, 0x00, 0x00, 0x7c0, 0xc60, 0x1830, 0x1830, 0x1830, 0x1830, 0x1830, 0x1e30, 0xc60, 0x1fc0, 0x00, 0x00, 0x00, //Q
  0x00, 0x00, 0x00, 0x7f0, 0xc30, 0xc30, 0xc30, 0xc30, 0x7f0, 0xc30, 0xc30, 0xc30, 0xc30, 0x00, 0x00, 0x00, //R
  0x00, 0x00, 0x00, 0x7e0, 0xc30, 0xc30, 0x30, 0x1e0, 0x700, 0xc00, 0xc30, 0xc30, 0x7e0, 0x00, 0x00, 0x00, //S
  0x00, 0x00, 0x00, 0xff0, 0x180, 0x180, 0x180, 0x180, 0x180, 0x180, 0x180, 0x180, 0x180, 0x00, 0x00, 0x00, //T
  0x00, 0x00, 0x00, 0xc30, 0xc30, 0xc30, 0xc30, 0xc30, 0xc30, 0xc30, 0xc30, 0xc30, 0x7e0, 0x00, 0x00, 0x00, //U
  0x00, 0x00, 0x00, 0xc30, 0xc30, 0xc30, 0x660, 0x660, 0x660, 0x3c0, 0x3c0, 0x180, 0x180, 0x00, 0x00, 0x00, //V
  0x00, 0x00, 0x00, 0x318c, 0x318c, 0x318c, 0x33cc, 0x1bd8, 0x1e78, 0x1e78, 0xc30, 0xc30, 0xc30, 0x00, 0x00, 0x00, //W
  0x00, 0x00, 0x00, 0xc30, 0xc30, 0x660, 0x3c0, 0x180, 0x180, 0x3c0, 0x660, 0xc30, 0xc30, 0x00, 0x00, 0x00, //X
  0x00, 0x00, 0x00, 0xc30, 0xc30, 0x660, 0x660, 0x3c0, 0x3c0, 0x180, 0x180, 0x180, 0x180, 0x00, 0x00, 0x00, //Y
  0x00, 0x00, 0x00, 0xff0, 0xc00, 0x600, 0x300, 0x180, 0x180, 0xc0, 0x60, 0x30, 0xff0, 0x00, 0x00, 0x00, //Z
  0x00, 0x00, 0x00, 0x7c0, 0xc60, 0xc60, 0xc60, 0xc60, 0xc60, 0xc60, 0xc60, 0xc60, 0x7c0, 0x00, 0x00, 0x00, //0
  0x00, 0x00, 0x00, 0x180, 0x1c0, 0x180, 0x180, 0x180, 0x180, 0x180, 0x180, 0x180, 0x180, 0x00, 0x00, 0x00, //1
  0x00, 0x00, 0x00, 0x7c0, 0xc60, 0xc60, 0xc00, 0x600, 0x300, 0x180, 0xc0, 0x60, 0xfe0, 0x00, 0x00, 0x00, //2
  0x00, 0x00, 0x00, 0x7c0, 0xc60, 0xc60, 0xc00, 0x780, 0xc00, 0xc00, 0xc60, 0xc60, 0x7c0, 0x00, 0x00, 0x00, //3
  0x00, 0x00, 0x00, 0x700, 0x700, 0x780, 0x780, 0x6c0, 0x6c0, 0x660, 0xfe0, 0x600, 0x600, 0x00, 0x00, 0x00, //4
  0x00, 0x00, 0x00, 0xfe0, 0x60, 0x60, 0x60, 0x7e0, 0xc60, 0xc00, 0xc00, 0xc60, 0x7c0, 0x00, 0x00, 0x00, //5
  0x00, 0x00, 0x00, 0x7c0, 0xc60, 0x60, 0x60, 0x7e0, 0xc60, 0xc60, 0xc60, 0xc60, 0x7c0, 0x00, 0x00, 0x00, //6
  0x00, 0x00, 0x00, 0xfe0, 0xc00, 0xc00, 0x600, 0x600, 0x300, 0x300, 0x180, 0x180, 0x180, 0x00, 0x00, 0x00, //7
  0x00, 0x00, 0x00, 0x7c0, 0xc60, 0xc60, 0xc60, 0x7c0, 0xc60, 0xc60, 0xc60, 0xc60, 0x7c0, 0x00, 0x00, 0x00, //8
  0x00, 0x00, 0x00, 0x7c0, 0xc60, 0xc60, 0xc60, 0xc60, 0xfc0, 0xc00, 0xc00, 0xc60, 0x7c0, 0x00, 0x00, 0x00, //9
};

unsigned char color = 0;
unsigned char Dot_char_cnt = 0; //도트매트릭스에 표시 될 문자 카운팅!
unsigned char flag_cnt = 0; //도트매트릭스에 표시 될 색상 카운팅!
unsigned char move_motion = 0;
unsigned int Move_cnt = 16;
unsigned int Move_cnt2 = 0;
unsigned int str_speed_cnt = 0;
volatile bool flag_Oe = 0;
volatile unsigned int cnt_time = 0;
unsigned int cnt_color = 0;
unsigned int cnt_char = 0;
ISR(TIMER2_OVF_vect) {
  //  static bool output = HIGH;
  //  digitalWrite(1, output);
  //  output = !output;
  static unsigned int string_moving_speed_value = 20;
  static unsigned int cnt, cnt2 = 0;

  if (cnt_char >= 50)
  {
    cnt_char = 0;
    if ( ++cnt_color >= 4) cnt_color = 1;
    switch (cnt_color)
    {
      case 1:
        color = Red;
        break;
      case 2:
        color = Green;
        break;
      case 3:
        color = Yellow;
        break;
    }
  }
  str_speed_cnt++;
  if (str_speed_cnt > string_moving_speed_value) //문자가 머문 후 시프트 시작!
  {
    str_speed_cnt = 0; //string moving speed counter
    Move_cnt--;
    Move_cnt2++;
    if (Move_cnt == 0 || Move_cnt2 == 16)
    {
      Move_cnt2 = 0;
      Move_cnt = 16;
      move_motion++;
      if (move_motion == 2)
      {
        move_motion = 0;
        cnt_char++;
      }
    }
  }
  TCNT2 |= 0x06;
}
void shift_Register(unsigned int out)
{
  unsigned char clk = 0;
  unsigned int HighBuff = 0;
  unsigned int LowBuff = 0;
  unsigned int sum = 0;
  for (clk = 0; clk < 16; clk++) { //8비트 데이터를 1비트씩 시프트 레지스터에 입력
    if (out & (0x8000 >> clk))
    {
      switch (color) {
        case 0:
          Data_Green_ON;
          Data_Red_ON;
          break;
        case 1:
          Data_Green_OFF;
          Data_Red_ON;
          break;
        case 2:
          Data_Green_ON;
          Data_Red_OFF;
          break;
      }
    }
    else
    {
      Data_Green_OFF;
      Data_Red_OFF;
    }
    Clk_ON;
    Clk_OFF;
  }
}
void Timer2Init()
{
  TCCR2A = 0x00;
  TCCR2B = 0x04;
  TIMSK2 = 0x01;
  TCNT2 |= 0x06;
  SREG = 0x80;
}

void setup() {
  DDRD=0XFC;
  DDRC=0X08;
  DDRB=0X30;
  Timer2Init();
  cnt_color = 1;
  color = Red;
}
void loop()
{
  for (int i = 0; i < 16; i++)
  {
    switch (move_motion) {
      case 0:
        shift_Register(pgm_read_word(&string_test[cnt_char][i]) << Move_cnt); //1char
        shift_Register(pgm_read_word(&string_test[cnt_char][i]) << Move_cnt); //2char
        break;
      case 1:
        shift_Register(pgm_read_word(&string_test[cnt_char][i]) >> Move_cnt2);//1char
        shift_Register(pgm_read_word(&string_test[cnt_char][i]) >> Move_cnt2);//2char
        break;       
    }
    switch (i) //ROW SHIFT!
    {
    case 0: A0_OFF; A1_OFF; A2_OFF; A3_OFF; break;        //1행 LED
    case 1: A0_ON; A1_OFF; A2_OFF; A3_OFF; break;       //2행 LED
    case 2: A0_OFF; A1_ON; A2_OFF; A3_OFF; break;       //3행 LED
    case 3: A0_ON; A1_ON; A2_OFF; A3_OFF; break;      //4행 LED
    case 4: A0_OFF; A1_OFF; A2_ON; A3_OFF; break;       //5행 LED
    case 5: A0_ON; A1_OFF; A2_ON; A3_OFF; break;      //6행 LED
    case 6: A0_OFF; A1_ON; A2_ON; A3_OFF; break;      //7행 LED
    case 7: A0_ON; A1_ON; A2_ON; A3_OFF; break;     //8행 LED
    case 8: A0_OFF; A1_OFF; A2_OFF; A3_ON; break;       //9행 LED
    case 9: A0_ON; A1_OFF; A2_OFF; A3_ON; break;      //10행 LED
    case 10: A0_OFF; A1_ON; A2_OFF; A3_ON; break;     //11행 LED
    case 11: A0_ON; A1_ON; A2_OFF; A3_ON; break;    //12행 LED
    case 12: A0_OFF; A1_OFF; A2_ON; A3_ON; break;     //13행 LED
    case 13: A0_ON; A1_OFF; A2_ON; A3_ON; break;    //14행 LED
    case 14: A0_OFF; A1_ON; A2_ON; A3_ON; break;    //15행 LED
    case 15: A0_ON; A1_ON; A2_ON; A3_ON; break;   //16행 LED
    }
    LE_ON;
    LE_OFF; //래치 출력
    OE_OFF;
    delayMicroseconds(500);
    OE_ON;
    }
}
